#include <yandex/maps/wiki/http/fbapi/models/task.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

Task::Task(json::Value data)
    : data_(std::move(data))
{}

std::string
Task::id() const
{
    return parseField<std::string>(data_, "id");
}

TaskStatus
Task::status() const
{
    return parseField<TaskStatus>(data_, "status");
}

Service
Task::service() const
{
    return parseField<Service>(data_, "service");
}

std::string
Task::serviceObjectId() const
{
    return parseField<std::string>(data_, "service_object_id");
}

std::string
Task::serviceObjectUrl() const
{
    return parseField<std::string>(data_, "service_object_url");
}

chrono::TimePoint
Task::createdAt() const
{
    return parseField<chrono::TimePoint>(data_, "created_at");
}

chrono::TimePoint
Task::updatedAt() const
{
    return parseField<chrono::TimePoint>(data_, "updated_at");
}

std::vector<std::string>
Task::attachedPhotos() const
{
    return parseField<std::vector<std::string>>(data_, "attached_photos");
}

OriginalTask
Task::originalTask() const
{
    return parseField<OriginalTask>(data_, "original_task");
}

const json::Value&
Task::data() const
{
    return data_;
}

TaskChanges
Task::sortedHistory() const
{
    auto changes = parseOptField<TaskChanges>(data_, "history");
    if (changes) {
        std::sort(
            changes->begin(),
            changes->end(),
            [](const auto& lhs, const auto& rhs){
                return lhs.createdAt() < rhs.createdAt();
            }
        );
        return changes.value();
    }
    return TaskChanges{};
}

std::optional<TaskResolution>
Task::nmapsIntegrationResolution() const
{
    auto integrationJson = data_["integration"]["services"]["nmaps"]["resolution"];
    if (!integrationJson.exists()) {
        return std::nullopt;
    }

    return fromJson<TaskResolution>(integrationJson);
}


Tasks::Tasks(json::Value data)
    : data_(std::move(data))
{}

std::vector<Task>
Tasks::tasks() const
{
    return parseField<std::vector<Task>>(data_, "tasks");
}

} // namespace maps::wiki::fbapi
