#include <yandex/maps/wiki/http/fbapi/models/task_change.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

TaskChange::TaskChange(json::Value data)
    : data_(std::move(data))
{}

TaskStatus TaskChange::status() const
{
    return parseField<TaskStatus>(data_, "status");
}

chrono::TimePoint TaskChange::createdAt() const
{
    return parseField<chrono::TimePoint>(data_, "created_at");
}

std::optional<Service> TaskChange::service() const
{
    return parseOptField<Service>(data_, "service");
}

std::optional<std::string> TaskChange::message() const
{
    return parseOptField<std::string>(data_, "message");
}

} // namespace maps::wiki::fbapi
