#include <yandex/maps/wiki/http/fbapi/models/toponym.h>

#include <maps/libs/enum_io/include/enum_io.h>
#include "parsing.h"

namespace maps::wiki::fbapi {

namespace {

constexpr enum_io::Representations<ToponymAddressComponentKind>
KIND_STRINGS {
    {ToponymAddressComponentKind::House, "house"},
    {ToponymAddressComponentKind::Street, "street"}
};

} // unnamed namespace

DEFINE_ENUM_IO(ToponymAddressComponentKind, KIND_STRINGS);


ToponymAddressComponent::ToponymAddressComponent(json::Value data)
    : data_(std::move(data))
{}

ToponymAddressComponentKind
ToponymAddressComponent::kind() const
{
    return parseField<ToponymAddressComponentKind>(data_, "kind");
}

std::optional<std::string>
ToponymAddressComponent::name() const
{
    return parseOptField<std::string>(data_, "name");
}


Toponym::Toponym(json::Value data)
    : data_(std::move(data))
{}

std::vector<ToponymAddressComponent>
Toponym::addressComponents() const
{
    return parseField<std::vector<ToponymAddressComponent>>(data_, "address");
}

std::optional<geolib3::Point2>
Toponym::center() const
{
    return parseOptField<geolib3::Point2>(data_, "center_point");
}

std::optional<std::string>
Toponym::name() const
{
    return parseOptField<std::string>(data_, "name");
}

std::optional<std::string>
Toponym::addressString() const
{
    return parseOptField<std::string>(data_, "address_string");
}

} // namespace maps::wiki::fbapi
