#include <maps/wikimap/mapspro/libs/http/fbapi/models/parsing.h>
#include <yandex/maps/wiki/http/fbapi/models/vehicle_restrictions.h>

namespace maps::wiki::fbapi {

VehicleRestrictions::VehicleRestrictions(json::Value data)
    : data_(std::move(data))
{}

std::optional<float> VehicleRestrictions::weight() const
{
    return parseOptField<float>(data_, "weight");
}

std::optional<float> VehicleRestrictions::maxWeight() const
{
    return parseOptField<float>(data_, "max_weight");
}

std::optional<float> VehicleRestrictions::payload() const
{
    return parseOptField<float>(data_, "payload");
}

std::optional<float> VehicleRestrictions::axleWeight() const
{
    return parseOptField<float>(data_, "axle_weight");
}

std::optional<float> VehicleRestrictions::height() const
{
    return parseOptField<float>(data_, "height");
}

std::optional<float> VehicleRestrictions::length() const
{
    return parseOptField<float>(data_, "length");
}

std::optional<float> VehicleRestrictions::width() const
{
    return parseOptField<float>(data_, "width");
}

std::optional<int> VehicleRestrictions::ecoClass() const
{
    return parseOptField<int>(data_, "eco_class");
}

std::optional<bool> VehicleRestrictions::hasTrailer() const
{
    return parseOptField<bool>(data_, "has_trailer");
}

} // namespace maps::wiki::fbapi
