#include "http_utils.h"

#include <maps/libs/log8/include/log8.h>

#include <chrono>
#include <thread>

namespace maps::wiki {

http::Response performHttpRequest(
    const std::function<http::Response()>& singlePerform,
    const maps::common::RetryPolicy& retryPolicy)
{
    return maps::common::retry(
        singlePerform,
        retryPolicy,
        [](const auto& maybeResponse) {
            return maybeResponse.valid() &&
                maybeResponse.get().responseClass() != http::ResponseClass::ServerError;
        },
        [](const auto& invalidResponse) {
            std::ostringstream msg;
            msg << "url: " << invalidResponse.url() << ", status: " << invalidResponse.status();
            return msg.str();
        }
    );
}

} // namespace maps::wiki
