#pragma once

#include <maps/libs/common/include/retry.h>

#include <maps/libs/http/include/http.h>

namespace maps::wiki {

namespace http_status {

constexpr int OK = 200;
constexpr int CREATED = 201;
constexpr int BAD_REQUEST = 400;
constexpr int NOT_FOUND = 404;

} // namespace http_status

http::Response performHttpRequest(
    const std::function<http::Response()>& singlePerform,
    const maps::common::RetryPolicy& retryPolicy);

} // namespace maps::wiki
