#pragma once

#include <functional>
#include <string>

namespace maps::wiki::fbapi {

using TvmTicketProvider = std::function<std::string()>;

class Configuration
{
public:
    explicit Configuration(std::string baseUrl)
        : baseUrl_(std::move(baseUrl))
    {
    }

    const std::string& baseUrl() const {
        return baseUrl_;
    }
    Configuration& setBaseUrl(std::string baseUrl) {
        baseUrl_ = std::move(baseUrl);
        return *this;
    }

    const TvmTicketProvider& tvmTicketProvider() const {
        return tvmTicketProvider_;
    }
    Configuration& setTvmTicketProvider(TvmTicketProvider tvmTicketProvider) {
        tvmTicketProvider_ = std::move(tvmTicketProvider);
        return *this;
    }

private:
    std::string baseUrl_;
    TvmTicketProvider tvmTicketProvider_;
};

} // namespace maps::wiki::fbapi
