#pragma once

#include <maps/libs/common/include/exception.h>


namespace maps::wiki::fbapi {

class FeedbackError: public RuntimeError
{
public:
    using RuntimeError::RuntimeError;
};

class KeyNotFoundError: public FeedbackError
{};

class BadRequestError: public FeedbackError
{
public:
    explicit BadRequestError(std::string what)
        : FeedbackError(std::move(what)) {}
};

} // namespace maps::wiki::fbapi
