#pragma once

/**
 * C++ interface for HTTP API of Feedback service
 * doc: https://github.yandex-team.ru/vanish/maps-feedback/tree/master/doc
 *
 * Two logical layers are presented
 * 1) class Gateway: each method corresponds http endpoint, no extra tricky logic except retries after server errors
 * 2) syntax sugar for common use cases, e.g. visitTasks
 */

#include <yandex/maps/wiki/http/fbapi/models/common.h>
#include <yandex/maps/wiki/http/fbapi/models/task.h>
#include <yandex/maps/wiki/http/fbapi/configuration.h>
#include <yandex/maps/wiki/http/fbapi/method_params.h>

#include <maps/libs/common/include/retry.h>

namespace maps::wiki::fbapi {

class IGateway
{
public:
    virtual Task taskById(
        const std::string& taskId,
        WithHistory withHistory = WithHistory::No) const = 0;

    virtual Tasks tasksByFilter(
        const TasksFilter& tasksFilter,
        const PageParams& pageParams,
        WithHistory withHistory = WithHistory::No) const = 0;

    virtual void changeTaskById(
        const std::string& taskId,
        const ChangeTaskParams& params) = 0;

    virtual ~IGateway() = default;
};

class Gateway: public IGateway
{
public:
    Gateway(
        Configuration configuration,
        const maps::common::RetryPolicy& retryPolicy);

    Task taskById(
        const std::string& taskId,
        WithHistory withHistory = WithHistory::No) const override;

    Tasks tasksByFilter(
        const TasksFilter& tasksFilter,
        const PageParams& pageParams,
        WithHistory withHistory = WithHistory::No) const override;

    void changeTaskById(
        const std::string& taskId,
        const ChangeTaskParams& params) override;

private:
    Configuration configuration_;
    maps::common::RetryPolicy retryPolicy_;
};

void visitTasks(
    const IGateway& gateway,
    const TasksFilter& tasksFilter,
    WithHistory withHistory,
    std::function<bool(const Task&)> visitor);

} // namespace maps::wiki::fbapi
