#pragma once

#include <maps/libs/json/include/builder.h>

#include <yandex/maps/wiki/http/fbapi/models/task.h>

#include <optional>
#include <string>

namespace maps::wiki::fbapi {

class PageParams
{
public:
    const std::optional<size_t>& offset() const {
        return offset_;
    }
    PageParams& setOffset(size_t offset) {
        offset_ = offset;
        return *this;
    }

private:
    std::optional<size_t> offset_;
};


class TasksFilter
{
public:
    TasksFilter(Service service, TaskStatus status)
        : service_(service)
        , status_(status)
    {}

    Service service() const {
        return service_;
    }
    TaskStatus status() const {
        return status_;
    }

private:
    Service service_;
    TaskStatus status_;
};


class ChangeTaskParams
{
public:
    const std::optional<Service>& newService() const {
        return newService_;
    }
    ChangeTaskParams& setNewService(Service service) {
        newService_ = service;
        return *this;
    }

    const std::optional<std::string>& serviceObjectId() const {
        return serviceObjectId_;
    }
    ChangeTaskParams& setServiceObjectId(std::string serviceObjectId) {
        serviceObjectId_ = std::move(serviceObjectId);
        return *this;
    }

    const std::optional<Service>& actorService() const {
        return actorService_;
    }
    ChangeTaskParams& setActorService(Service service) {
        actorService_ = service;
        return *this;
    }

    const std::optional<TaskStatus>& newStatus() const {
        return newStatus_;
    }
    ChangeTaskParams& setNewStatus(TaskStatus status) {
        newStatus_ = status;
        return *this;
    }

    const std::optional<TaskResolution>& resolution() const {
        return resolution_;
    }
    ChangeTaskParams& setResolution(TaskResolution resolution) {
        resolution_ = resolution;
        return *this;
    }

    const std::optional<std::string>& message() const {
        return message_;
    }
    ChangeTaskParams& setMessage(std::string message) {
        message_ = std::move(message);
        return *this;
    }

    const std::optional<std::string>& requestTemplateId() const {
        return requestTemplateId_;
    }
    ChangeTaskParams& setRequestTemplateId(std::string value) {
        requestTemplateId_ = std::move(value);
        return *this;
    }

    ChangeTaskParams& update(ChangeTaskParams other);

    void json(maps::json::ObjectBuilder builder) const;

private:
    // Service to which the user feedback was intended for
    // It's ok not to specify it if you don't know destination service
    // for example in case of 'need_info' status
    //
    std::optional<Service> newService_;

    std::optional<std::string> serviceObjectId_;

    std::optional<TaskStatus> newStatus_;

    std::optional<std::string> requestTemplateId_;

    std::optional<TaskResolution> resolution_;

    // Service, which applies changes
    //
    std::optional<Service> actorService_;

    std::optional<std::string> message_;
};

} // namespace maps::wiki::fbapi
