#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::fbapi {

enum class Service
{
    Nmaps,
    Sprav,
    Support
};

DECLARE_ENUM_IO(Service);

enum class TaskStatus
{
    New,
    InProgress,
    NeedInfo,
    Accepted,
    Rejected,
    Published
};

DECLARE_ENUM_IO(TaskStatus);

enum class TaskResolution
{
    AutoCleanWeb,
    IncorrectData,
    NoData,
    NoInfo,
    ProhibitedByRules,
    RedirectToContentAuto,
    RedirectToContentBicycle,
    RedirectToContentBigTask,
    RedirectToContentMasstransit,
    RedirectToContentOther,
    RedirectToContentPedestrian,
    RedirectToContentRoadEvents,
    RedirectToContentToponym,
    RedirectToContentTruck,
    RedirectToPlatformAuto,
    RedirectToPlatformBicycle,
    RedirectToPlatformMasstransit,
    RedirectToPlatformToponym,
    RedirectToPlatformTruck,
    RedirectToSprav,
    RedirectToSupport,
    Spam,
};

DECLARE_ENUM_IO(TaskResolution);

enum class WithHistory
{
    Yes,
    No
};

DECLARE_ENUM_IO(WithHistory);

enum class TravelMode
{
    Auto,
    Masstransit,
    Pedestrian,
    Bicycle,
    Scooter,
    Taxi,
    Truck
};

DECLARE_ENUM_IO(TravelMode);

enum class RouteErrorType
{
    LeftTurnProhibited,
    RightTurnProhibited,
    UTurnProhibited,
    Barrier,
    ProhibitingSign,
    Obstruction,
    PoorCondition,
    NoRoad,
    Other
};

DECLARE_ENUM_IO(RouteErrorType);

} // namespace maps::wiki::fbapi
