#pragma once

#include <yandex/maps/wiki/http/fbapi/models/entrance.h>
#include <yandex/maps/wiki/http/fbapi/models/fence.h>
#include <yandex/maps/wiki/http/fbapi/models/other_context.h>
#include <yandex/maps/wiki/http/fbapi/models/parking.h>
#include <yandex/maps/wiki/http/fbapi/models/road.h>
#include <yandex/maps/wiki/http/fbapi/models/route_answer_context.h>
#include <yandex/maps/wiki/http/fbapi/models/route_question_context.h>
#include <yandex/maps/wiki/http/fbapi/models/stop.h>
#include <yandex/maps/wiki/http/fbapi/models/toponym.h>
#include <yandex/maps/wiki/http/fbapi/exception.h>

#include <maps/libs/json/include/value.h>

#include <optional>

namespace maps::wiki::fbapi {

///
///
class QuestionContext
{
public:
    explicit QuestionContext(json::Value data)
        : data_(std::move(data))
    {}

    const json::Value& data() const
    {
        return data_;
    }

    template<class T>
    T as() const
    {
        throw FeedbackError() << "Unsupported context type";
    }

private:
    json::Value data_;
};

template<>
Entrance QuestionContext::as() const;

template<>
RouteQuestionContext QuestionContext::as() const;

template<>
std::optional<Stop> QuestionContext::as() const;

template<>
Toponym QuestionContext::as() const;

///
///
class AnswerContext
{
public:
    explicit AnswerContext(json::Value data)
        : data_(std::move(data))
    {}

    const json::Value& data() const
    {
        return data_;
    }

    template<class T>
    T as() const
    {
        throw FeedbackError() << "Unsupported context type";
    }

private:
    json::Value data_;
};

template<>
Entrance AnswerContext::as() const;

template<>
Fence AnswerContext::as() const;

template<>
OtherContext AnswerContext::as() const;

template<>
std::optional<Parking> AnswerContext::as() const;

template<>
std::optional<Road> AnswerContext::as() const;

template<>
RouteAnswerContext AnswerContext::as() const;

template<>
std::optional<Stop> AnswerContext::as() const;

template<>
Toponym AnswerContext::as() const;

} // namespace maps::wiki::fbapi
