#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>

namespace maps::wiki::fbapi {

class Gate
{
public:
    explicit Gate(json::Value data);

    geolib3::Point2 center() const;

private:
    json::Value data_;
};
using Gates = std::vector<Gate>;


class Fence
{
public:
    explicit Fence(json::Value data);

    std::optional<geolib3::Point2> center() const;
    geolib3::PointsVector points() const;
    Gates gates() const;

private:
    json::Value data_;
};

} // namespace maps::wiki::fbapi
