#pragma once

#include "context.h"
#include "version.h"

#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>

#include <optional>

namespace maps::wiki::fbapi {

class FormContext
{
public:
    explicit FormContext(json::Value data);

    std::optional<std::string> searchText() const;
    bool fromPush() const;

private:
    json::Value data_;
};

class OriginalTaskMetadata
{
public:
    explicit OriginalTaskMetadata(json::Value data);

    std::string clientId() const;
    std::string version() const;
    std::optional<Version> applicationVersion() const;
    std::optional<std::string> uuid() const;
    std::optional<std::string> deviceId() const;
    std::optional<std::string> sessionId() const;
    std::optional<uint64_t> uid() const;
    std::optional<std::string> yandexuid() const;
    std::optional<std::string> ip() const;
    std::optional<std::string> fingerprint() const;
    std::optional<std::string> userAgent() const;
    std::string locale() const;

private:
    json::Value data_;
};


class OriginalTask
{
public:
    explicit OriginalTask(json::Value data);

    std::string formId() const;
    std::string questionId() const;
    std::string answerId() const;
    std::optional<std::string> objectId() const;
    std::optional<std::string> objectUri() const;
    std::optional<std::string> userEmail() const;
    std::optional<std::string> objectUrl() const;
    std::optional<QuestionContext> questionContext() const;
    std::optional<AnswerContext> answerContext() const;
    std::optional<std::string> message() const;
    std::optional<std::string> supportMessage() const;
    geolib3::Point2 formPoint() const;
    OriginalTaskMetadata metadata() const;
    std::optional<FormContext> formContext() const;

private:
    json::Value data_;
};

} // namespace maps::wiki::fbapi
