#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/http/fbapi/models/common.h>
#include <yandex/maps/wiki/http/fbapi/models/vehicle_restrictions.h>

namespace maps::wiki::fbapi {

class RouteErrorProhibitingSignContext
{
public:
    explicit RouteErrorProhibitingSignContext(json::Value data);

    std::optional<VehicleRestrictions> vehicleRestrictions() const;

private:
    json::Value data_;
};

class RouteError
{
public:
    explicit RouteError(json::Value data);

    RouteErrorType type() const;
    geolib3::Point2 point() const;
    std::optional<RouteErrorProhibitingSignContext> prohibitingSignContext() const;

private:
    json::Value data_;
};
using RouteErrors = std::vector<RouteError>;


class RouteAnswerSegment
{
public:
    explicit RouteAnswerSegment(json::Value data);

    TravelMode travelMode() const;
    geolib3::PointsVector points() const;

private:
    json::Value data_;
};
using RouteAnswerSegments = std::vector<RouteAnswerSegment>;


class RouteAnswerContext
{
public:
    explicit RouteAnswerContext(json::Value data);

    RouteErrors errors() const;
    RouteAnswerSegments segments() const;

private:
    json::Value data_;
};


} // namespace maps::wiki::fbapi
