#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>
#include <yandex/maps/wiki/http/fbapi/models/common.h>
#include <yandex/maps/wiki/http/fbapi/models/vehicle_restrictions.h>

#include <vector>

namespace maps::wiki::fbapi {

class RouteQuestionSegment
{
public:
    explicit RouteQuestionSegment(json::Value data);

    TravelMode travelMode() const;
    geolib3::Point2 from() const;
    geolib3::Point2 to() const;

private:
    json::Value data_;
};
using RouteQuestionSegments = std::vector<RouteQuestionSegment>;


class RouteQuestionContext
{
public:
    explicit RouteQuestionContext(json::Value data);

    TravelMode travelMode() const;
    bool trafficJams() const;
    geolib3::PointsVector wayPoints() const;
    geolib3::PointsVector viaPoints() const;
    std::optional<std::string> encodedPoints() const;
    RouteQuestionSegments segments() const;
    std::optional<std::string> uri() const;
    std::optional<chrono::TimePoint> departureAt() const;
    std::optional<VehicleRestrictions> vehicleRestrictions() const;

private:
    json::Value data_;
};


} // namespace maps::wiki::fbapi
