#pragma once

#include <yandex/maps/wiki/http/fbapi/models/original_task.h>
#include <yandex/maps/wiki/http/fbapi/models/task_change.h>
#include <yandex/maps/wiki/http/fbapi/models/common.h>

#include <maps/libs/chrono/include/time_point.h>

#include <vector>

namespace maps::wiki::fbapi {

class Task
{
public:
    explicit Task(json::Value data);

    std::string id() const;
    TaskStatus status() const;
    Service service() const;
    std::string serviceObjectId() const;
    std::string serviceObjectUrl() const;
    chrono::TimePoint createdAt() const;
    chrono::TimePoint updatedAt() const;
    std::vector<std::string> attachedPhotos() const;
    OriginalTask originalTask() const;
    TaskChanges sortedHistory() const; // sorted by createdAt in ascending order
    std::optional<TaskResolution> nmapsIntegrationResolution() const;

    const json::Value& data() const;

private:
    json::Value data_;
};


class Tasks
{
public:
    explicit Tasks(json::Value data);

    std::vector<Task> tasks() const;

private:
    json::Value data_;
};

} // namespace maps::wiki::fbapi
