#pragma once

#include "common.h"

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/json/include/value.h>

namespace maps::wiki::fbapi {

class TaskChange
{
public:
    explicit TaskChange(json::Value data);

    TaskStatus status() const;
    chrono::TimePoint createdAt() const;
    std::optional<Service> service() const;
    std::optional<std::string> message() const;

private:
    json::Value data_;
};

using TaskChanges = std::vector<TaskChange>;

} // namespace maps::wiki::fbapi
