#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/json/include/value.h>
#include <maps/libs/geolib/include/point.h>

#include <optional>
#include <vector>

namespace maps::wiki::fbapi {

enum class ToponymAddressComponentKind
{
    House,
    Street
};

DECLARE_ENUM_IO(ToponymAddressComponentKind);


class ToponymAddressComponent
{
public:
    explicit ToponymAddressComponent(json::Value data);

    ToponymAddressComponentKind kind() const;
    std::optional<std::string> name() const;

private:
    json::Value data_;
};

class Toponym
{
public:
    explicit Toponym(json::Value data);

    std::vector<ToponymAddressComponent> addressComponents() const;
    std::optional<geolib3::Point2> center() const;
    std::optional<std::string> name() const;
    std::optional<std::string> addressString() const;

    json::Value data_;
};


} // namespace maps::wiki::fbapi
