#pragma once

#include <maps/libs/introspection/include/comparison.h>

namespace maps::wiki::fbapi {

class Version
{
public:
    Version(unsigned major, unsigned minor, unsigned patch);
    unsigned getMajor() const;
    unsigned getMinor() const;
    unsigned getPatch() const;

private:
    unsigned major_;
    unsigned minor_;
    unsigned patch_;
};

inline auto introspect(const Version& version)
{
    return std::make_tuple(
        version.getMajor(),
        version.getMinor(),
        version.getPatch()
    );
}

using introspection::operator==;
using introspection::operator<=;
using introspection::operator<;

} // namespace maps::wiki::fbapi
