#pragma once

/**
 * Tanker HTTP API client implementation
 * https://doc.yandex-team.ru/Tanker/api-reference/concepts/about.xml
 */

#include <maps/libs/common/include/retry.h>

#include <string>
#include <unordered_map>

namespace maps::wiki::tanker {

struct Configuration
{
    Configuration(
            std::string host,
            std::string projectId,
            std::string oauthToken)
        : host(std::move(host))
        , projectId(std::move(projectId))
        , oauthToken(std::move(oauthToken))
    {}

    std::string host;
    std::string projectId;
    std::string oauthToken;
};

using TranslationMap = std::unordered_map<std::string, std::string>;

class IGateway
{
public:
    virtual TranslationMap translations(
        const std::string& keysetId,
        const std::string& language) const = 0;

    virtual ~IGateway() = default;
};

class Gateway: public IGateway
{
public:
    explicit Gateway(
        Configuration configuration,
        const maps::common::RetryPolicy& retryPolicy =
            maps::common::RetryPolicy().setInitialCooldown(std::chrono::seconds{60}));

    TranslationMap translations(
        const std::string& keysetId,
        const std::string& language) const override;

private:
    Configuration configuration_;
    maps::common::RetryPolicy retryPolicy_;
};

} // namespace maps::wiki::tanker
