#include <yandex/maps/wiki/http/tanker/tanker.h>

#include "http_utils.h"

#include <maps/libs/http/include/url.h>
#include <maps/libs/json/include/value.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::tanker {

namespace {

const std::chrono::milliseconds HTTP_TIMEOUT = std::chrono::seconds{3};

} // namespace

Gateway::Gateway(
        Configuration configuration,
        const maps::common::RetryPolicy& retryPolicy)
    : configuration_(std::move(configuration))
    , retryPolicy_(retryPolicy)
{
}

TranslationMap Gateway::translations(
    const std::string& keysetId,
    const std::string& language) const
{
    http::URL url("https://" + configuration_.host + "/keysets/json/");
    url.addParam("project-id", configuration_.projectId);
    url.addParam("keyset-id", keysetId);
    url.addParam("language", language);

    DEBUG() << "tanker request url: " << url;
    http::Client httpClient;
    httpClient.setTimeout(HTTP_TIMEOUT);

    auto singlePerform = [&]() {
        http::Request request(httpClient, http::GET, url.toString());
        request.addHeader("Authorization", "OAuth " + configuration_.oauthToken);
        return request.perform();
    };

    auto response = performHttpRequest(singlePerform, retryPolicy_);

    REQUIRE(
        response.status() == http_status::OK,
        "unexpected http code: " << response.status() << "; GET url: " << url);

    auto json = json::Value(response.body());
    ASSERT(json.isObject());
    ASSERT(json.hasField(language));

    return json[language].as<TranslationMap>();
}

} // namespace maps::wiki::tanker
