#include "boardings.h"

#include <maps/wikimap/mapspro/libs/masstransit/masstransit.h>
#include <yandex/maps/wiki/common/string_utils.h>

namespace maps::wiki::masstransit {

namespace {

const std::string BOARDINGS_SCHEMA = "train_car:";

} // namespace

YmapsdfBoardingHandler::YmapsdfBoardingHandler(Masstransit& masstransit)
    : YmapsdfObjectHandler(masstransit, masstransit.boardings)
{ }

std::vector<FtType>
YmapsdfBoardingHandler::ftTypes() const
{
    return {
        FtType::TransportMetroTransitionBoarding,
        FtType::TransportMetroPassagewayBoarding
    };
}

StringVector
YmapsdfBoardingHandler::attrs() const
{
    return {attr::BOARDING_OPTIONS, attr::ONEWAY};
}

StringVector
YmapsdfBoardingHandler::rolesToSlaves() const
{
    return {role::STATION_PREVIOUS, role::STATION_NEXT};
}

void
YmapsdfBoardingHandler::addObject(const pqxx::row& tuple)
{
    auto boarding = std::make_shared<Boarding>();

    boarding->id = getAttr<DBID>(tuple, ymapsdf::ID);
    boarding->transitionId = getAttr<DBID>(tuple, ymapsdf::P_FT_ID, 0);
    boarding->ftType = getAttr<FtType>(tuple, ymapsdf::FT_TYPE_ID);
    boarding->prevStopId = getAttr<DBID>(tuple, role::STATION_PREVIOUS);

    boarding->nextStopId = getAttr<DBID>(tuple, role::STATION_NEXT, 0);
    boarding->direction = getAttr<Direction>(tuple, attr::ONEWAY, Direction::Forward);

    auto options = common::split(getAttr<std::string>(tuple, attr::BOARDING_OPTIONS), "|");
    for (auto& option : options) {
        option = BOARDINGS_SCHEMA + option;
    }
    boarding->boardingOptions = common::join(options, ",");
    insert(boarding->id, boarding);
}

MtrBoardingHandler::MtrBoardingHandler(Masstransit& masstransit)
    : MtrObjectHandler(masstransit, masstransit.boardings)
{ }

void
MtrBoardingHandler::writeObject(StreamMap& ostreams, const Object& object)
{
    const auto& boarding = dynamic_cast<const Boarding&>(object);
    const auto& transition = masstransit_.transitions[boarding.transitionId];
    const auto prevStopId = idMap().getMtrId(boarding.prevStopId);
    const auto srcStopMtrId = idMap().getMtrId(transition.srcStopId);
    const auto dstStopOrExitId = idMap().getMtrId(transition.dstStopId);
    std::string nextStopId;
    if (boarding.nextStopId) {
        nextStopId = idMap().getMtrId(boarding.nextStopId);
    }
    auto& ostream = ostreams[fileNames().front()];
    ostream << prevStopId << FIELD_SEPARATOR;
    if (boarding.direction == Direction::Backward) {
        ostream << dstStopOrExitId << FIELD_SEPARATOR << srcStopMtrId << FIELD_SEPARATOR;
    } else {
        ostream << srcStopMtrId << FIELD_SEPARATOR << dstStopOrExitId << FIELD_SEPARATOR;
    }
    ostream << nextStopId << FIELD_SEPARATOR << boarding.boardingOptions << std::endl;
}

} // namespace maps::wiki::masstransit
