#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Boarding : public Object {
    DBID id;
    DBID prevStopId;
    DBID nextStopId = 0;
    std::string boardingOptions;
    Direction direction = Direction::Forward;
    DBID transitionId;
    FtType ftType;
};

class YmapsdfBoardingHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfBoardingHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "boarding"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToSlaves() const override;

    void addObject(const pqxx::row& tuple) override;
    bool allowNm() const override { return false; }
};

class MtrBoardingHandler : public MtrObjectHandler {
public:
    explicit MtrBoardingHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::BOARDINGS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
