#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Connector : public Object {
    DBID connectorId;
    DBID srcThreadId;
    DBID dstThreadId;
    FtType ftType;
    bool isPredictable;
};

class YmapsdfConnectorHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfConnectorHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "connector"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToSlaves() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrConnectorHandler : public MtrObjectHandler {
public:
    explicit MtrConnectorHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::CONNECTORS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
