#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

class YmapsdfBusConnectorGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfBusConnectorGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "rd_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class YmapsdfTramConnectorGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfTramConnectorGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "tram_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class YmapsdfMetroConnectorGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfMetroConnectorGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "metro_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class MtrConnectorGeometryHandler : public MtrObjectHandler {
public:
    explicit MtrConnectorGeometryHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::CONNECTOR_GEOMETRY}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
