#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Name {
    Name();

    locale::Lang lang;
    bool isLocal;
    size_t nameType;
    std::string name;
};

struct Localization : public Object {
    DBID objectId;
    MtrType mtrType;
    std::vector<Name> names;
};

class YmapsdfLocalizationHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfLocalizationHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "name"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadIdsSql() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void update() override;

    void replaceExitNamesWithStationNames(DBID exitId);
};

class MtrLocalizationHandler : public MtrObjectHandler {
public:
    explicit MtrLocalizationHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::L10N}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
