#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

#include <yandex/maps/wiki/common/schedule.h>

namespace maps::wiki::masstransit {

struct Operator : public Object
{
    explicit Operator(const common::Schedule& schedule);

    DBID operatorId;
    Point point;
    common::Schedule schedule;
};

class YmapsdfOperatorHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfOperatorHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "operator"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
};

} // namespace maps::wiki::masstransit
