#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Route : public Object {
    DBID routeId;
    DBID operatorId;
    FtType ftType;
    std::string name;
    std::string style;
    std::string uri;
};

class YmapsdfRouteHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfRouteHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "route"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToMasters() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrRouteHandler : public MtrObjectHandler {
public:
    explicit MtrRouteHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::ROUTES}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
