#include "route_aliases.h"

#include <maps/wikimap/mapspro/libs/masstransit/masstransit.h>

namespace maps::wiki::masstransit {

YmapsdfRouteAliasHandler::YmapsdfRouteAliasHandler(Masstransit& masstransit)
    : YmapsdfObjectHandler(masstransit, masstransit.routeAliases)
{ }

std::vector<FtType>
YmapsdfRouteAliasHandler::ftTypes() const
{
    return {FtType::TransportRouteAlias};
}

StringVector
YmapsdfRouteAliasHandler::attrs() const
{
    return {ymapsdf::NAME, ymapsdf::FT_TYPE_ID, attr::PRIORITY};
}

StringVector
YmapsdfRouteAliasHandler::rolesToMasters() const
{
    return {role::ALIAS};
}

void
YmapsdfRouteAliasHandler::addObject(const pqxx::row& tuple)
{
    auto alias = std::make_shared<RouteAlias>();

    alias->aliasId = getAttr<DBID>(tuple, ymapsdf::ID);
    alias->routeId = getAttr<DBID>(tuple, role::ALIAS);
    alias->altType = getAttr<FtType>(tuple, ymapsdf::FT_TYPE_ID);
    alias->altName = getAttr<std::string>(tuple, ymapsdf::NAME, "");
    alias->priority = getAttr<size_t>(tuple, attr::PRIORITY, 0);

    insert(alias->aliasId, alias);
}

MtrRouteAliasHandler::MtrRouteAliasHandler(Masstransit& masstransit)
    : MtrObjectHandler(masstransit, masstransit.routeAliases)
{ }

void
MtrRouteAliasHandler::writeObject(StreamMap& ostreams, const Object& object)
{
    const RouteAlias& alias = dynamic_cast<const RouteAlias&>(object);
    auto& ostream = ostreams[fileNames().front()];

    ostream
        << idMap().getMtrId(alias.routeId) << FIELD_SEPARATOR
        << toString(alias.altType) << FIELD_SEPARATOR
        << alias.altName << FIELD_SEPARATOR;
    if (alias.priority > 0) {
        ostream << alias.priority;
    }
    ostream << std::endl;
}

} // namespace maps::wiki::masstransit
