#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct RouteAlias : public Object {
    DBID aliasId;
    DBID routeId;
    FtType altType;
    std::string altName;
    size_t priority; // 0 for infinity
};

class YmapsdfRouteAliasHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfRouteAliasHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "alias"; }

    std::vector<FtType> ftTypes() const override;
    bool allowFtTypeId() const override { return false; }
    bool allowNm() const override { return false; }
    StringVector attrs() const override;
    StringVector rolesToMasters() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrRouteAliasHandler : public MtrObjectHandler {
public:
    explicit MtrRouteAliasHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::ALIASES}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
