#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Stop : public Object {
    Stop();

    DBID stopId;
    DBID parentStopId; // for exit only
    std::string name; // ignore while converting to ymapsdf
    FtType ftType;
    Point point;
    bool isWaypoint;

    std::set<DBID> routeIds; // collected by ThreadHandler's
};

class YmapsdfStopHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfStopHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "stop"; }

    std::vector<FtType> ftTypes() const override;
    bool allowPointGeom() const override { return true; }
    StringVector attrs() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrStopHandler : public MtrObjectHandler {
public:
    explicit MtrStopHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::STOPS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
