#include "stop_closure.h"

#include <maps/wikimap/mapspro/libs/masstransit/masstransit.h>

namespace maps::wiki::masstransit {

StopClosure::StopClosure(DBID id)
    : stopClosureId(id)
{ }

MtrStopClosureHandler::MtrStopClosureHandler(Masstransit& masstransit)
    : MtrObjectHandler(masstransit, masstransit.stopClosures)
{ }

void
MtrStopClosureHandler::writeObject(StreamMap& ostreams, const Object& object)
{
    const auto& stopClosure = dynamic_cast<const StopClosure&>(object);
    const auto mtrId = idMap().getMtrId(stopClosure.stopClosureId);

    auto& ostream = ostreams[fileNames().front()];
    ostream << mtrId << std::endl;
}

} // namespace maps::wiki::masstransit
