#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::masstransit {

enum class ThreadType {
    Linear,
    Circular
};

DECLARE_ENUM_IO(ThreadType);

struct Thread : public Object {
    DBID threadId;
    DBID routeId;
    ThreadType type;
    FtType ftType;
    std::string name;
};

class YmapsdfThreadHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfThreadHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "thread"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToMasters() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class MtrThreadHandler : public MtrObjectHandler {
public:
    explicit MtrThreadHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::THREADS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
