#include "thread_closure.h"

#include <maps/wikimap/mapspro/libs/masstransit/masstransit.h>

namespace maps::wiki::masstransit {

ThreadClosure::ThreadClosure(DBID id)
    : threadClosureId(id)
{ }

MtrThreadClosureHandler::MtrThreadClosureHandler(Masstransit& masstransit)
    : MtrObjectHandler(masstransit, masstransit.threadClosures)
{ }

void
MtrThreadClosureHandler::writeObject(StreamMap& ostreams, const Object& object)
{
    const auto& threadClosure = dynamic_cast<const ThreadClosure&>(object);
    const auto mtrId = idMap().getMtrId(threadClosure.threadClosureId);

    auto& ostream = ostreams[fileNames().front()];
    ostream << mtrId << std::endl;
}

} // namespace maps::wiki::masstransit
