#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

class YmapsdfBusGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfBusGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "rd_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class YmapsdfTramGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfTramGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "tram_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class YmapsdfMetroGeometryHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfMetroGeometryHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "metro_el"; }

    std::vector<FtType> ftTypes() const override;
    std::string loadRowsSqlTemplate() const override;

    void addObject(const pqxx::row& tuple) override;
    void updateObject(Object& object) override;
};

class MtrThreadGeometryHandler : public MtrObjectHandler {
public:
    explicit MtrThreadGeometryHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::GEOMETRY}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
