#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>
#include "travel_time.h"

#include <map>
#include <vector>

namespace maps::wiki::masstransit {

struct ThreadStopFlags {
    ThreadStopFlags();
    explicit ThreadStopFlags(const pqxx::row& tuple);

    bool noBoarding;
    bool noDropOff;
    bool important;
};

bool
isWaypoint(const ThreadStopFlags& flags);

struct ThreadStop {
    ThreadStop();

    DBID threadStopId;
    DBID stopId;
    size_t seqId;
    ThreadStopFlags flags;
};

struct ThreadStops : public Object {
    DBID threadId;
    std::vector<ThreadStop> stopsInThread;

    struct MtrLoadData {
        std::map<DBID, ThreadStop> previousIdToThreadStop;
        std::map<DBID, TravelTimeDatum> previousIdToTravelTime;
    };
    MtrLoadData mtr;
};

class YmapsdfThreadStopsHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfThreadStopsHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "thread_stop"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToMasters() const override;
    StringVector rolesToSlaves() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrThreadStopsHandler : public MtrObjectHandler {
public:
    explicit MtrThreadStopsHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::THREAD_STOPS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
