#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>
#include <maps/wikimap/mapspro/libs/masstransit/ymapsdf_object_handler.h>

namespace maps::wiki::masstransit {

struct Transition : public Object {
    DBID transitionId;
    DBID srcStopId;
    DBID dstStopId;
    bool isVirtual;
    std::optional<bool> blocked;
    std::optional<size_t> timeSec;
    std::optional<Direction> direction;
};

class YmapsdfTransitionHandler : public YmapsdfObjectHandler {
public:
    explicit YmapsdfTransitionHandler(Masstransit& masstransit);

private:
    std::string name() const override { return "transition"; }

    std::vector<FtType> ftTypes() const override;
    StringVector attrs() const override;
    StringVector rolesToSlaves() const override;

    void addObject(const pqxx::row& tuple) override;
};

class MtrTransitionHandler : public MtrObjectHandler {
public:
    explicit MtrTransitionHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::TRANSITIONS}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

} // namespace maps::wiki::masstransit
