#pragma once

#include <maps/wikimap/mapspro/libs/masstransit/mtr_object_handler.h>

#include <map>
#include <vector>

namespace maps::wiki::masstransit {

struct TravelTimeDatum {
    size_t seqId = 0;
    size_t arrivalTimeSec = 0;
    size_t departureTimeSec = 0;
};

struct TravelTime : public Object {
    TravelTime(DBID travelTimeId, DBID threadId);

    DBID travelTimeId;
    DBID threadId;
    std::vector<TravelTimeDatum> data;
};

class MtrTravelTimeHandler : public MtrObjectHandler {
public:
    explicit MtrTravelTimeHandler(Masstransit& masstransit);

private:
    StringVector fileNames() const override { return {filename::TRAVEL_TIME}; }
    void writeObject(StreamMap& ostreams, const Object& object) override;
};

std::string getTravelTimeMtrId(DBID baseId);

} // namespace maps::wiki::masstransit
