#pragma once

#include <yandex/maps/wiki/common/rd/cond_type.h>
#include <yandex/maps/wiki/common/rd/direction.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/routing/condition.h>
#include <yandex/maps/wiki/routing/element.h>
#include <yandex/maps/wiki/routing/stop.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

#include <maps/libs/ymapsdf/include/ft.h>

#include <util/system/type_name.h>

#include <boost/lexical_cast.hpp>
#include <iostream>
#include <string>
#include <time.h>
#include <vector>

namespace maps::wiki::masstransit {

using StringVector = std::vector<std::string>;

using DBID = revision::DBID;
using FtType = ymapsdf::ft::Type;
using Point = geolib3::Point2;
using Polyline = geolib3::Polyline2;

using Conditions = routing::Conditions;
using Direction = routing::Direction;
using ElementEnd = routing::ElementEnd;
using Elements = routing::Elements;
using Ids = routing::Ids;
using StopPoints = routing::Stops;

enum class MtrType {
    Stop,
    Route,
    Thread,
    Connector,
    ThreadStop,
    Transition,
    Schedule,
    TravelTime,
    RouteAlias
};

MtrType mtrType(FtType ftType);

std::string toString(MtrType mtrType);
std::string toString(FtType ftType);

common::ConditionType toConditionType(DBID condTypeId);

template<typename T>
T to(const std::string& value)
{
    try {
        return boost::lexical_cast<T>(value);
    } catch (const std::exception& ex) {
        throw RuntimeError() << "Unable to convert '" << value << "' to " << TypeName<T>();
    }
}

} // namespace maps::wiki::masstransit
