#include <yandex/maps/wiki/masstransit/convert.h>

#include "masstransit.h"

namespace maps::wiki::masstransit {

void
ymapsdf2mtr(pgpool3::Pool& ymapsdfPool,
    const std::string& sourceYmapsdfSchema,
    const std::string& targetMtrDirectory,
    const std::string& dataErrorLogFilePath)
{
    Params params;
    params.dataErrorLogFilePath = dataErrorLogFilePath;

    Masstransit mtrData(params);
    mtrData.readFromYmapsdf(ymapsdfPool, sourceYmapsdfSchema);
    mtrData.writeToMtr(targetMtrDirectory);

    REQUIRE(!mtrData.failed(), "ymapsdf2mtr failed");
}

} // namespace maps::wiki::masstransit
