#pragma once

#include "common.h"

#include <maps/libs/pgpool/include/pgpool3.h>

#include <pqxx/pqxx>

namespace maps::wiki::masstransit {

class DBHelper {
public:
    DBHelper(pgpool3::Pool& ymapsdfPool, const std::string& schemaName);

    pqxx::result execRead(const std::string& query);
    pqxx::result execWrite(const std::string& query);

    void dropSchema();
    void createSchema();
    void finalizeSchema();

    DBID maxId();

private:
    pgpool3::TransactionHandle writeableTransaction();
    pgpool3::TransactionHandle slaveTransaction();

    pqxx::result exec(pqxx::transaction_base& txn, const std::string& query);
    void commit(pqxx::transaction_base& txn);

    pgpool3::Pool& ymapsdfPool_;
    const std::string schemaName_;
};

} // namespace maps::wiki::masstransit
