#include <yandex/maps/wiki/masstransit/geobase.h>

#include <mutex>

namespace maps::wiki::masstransit {

namespace {

std::string GEODATA_BIN = "/var/cache/geobase/geodata6.bin";
std::mutex geodataBinMutex;

} // namespace

std::string getGeodataBinPath()
{
    std::lock_guard<std::mutex> lock(geodataBinMutex);
    return GEODATA_BIN;
}

void setGeodataBinPath(const std::string& path)
{
    std::lock_guard<std::mutex> lock(geodataBinMutex);
    GEODATA_BIN = path;
}

} // namespace maps::wiki::masstransit
