#pragma once

#include "common.h"

#include <atomic>
#include <mutex>

namespace maps::wiki::masstransit {

class IdMap {
public:
    IdMap();

    void initLastDBID(DBID maxId);

    void add(DBID dbId, const std::string& mtrId, MtrType mtrType);

    DBID newDBID();
    DBID getDBID(const std::string& mtrId, MtrType mtrType);
    std::string getMtrId(DBID dbId) const;

private:
    struct MtrId {
        std::string id;
        MtrType type;
        bool operator<(const MtrId& rhs) const;
    };

    void registerIdPair(DBID dbId, const MtrId& mtrId);

    std::map<DBID, MtrId> db2mtr_;
    std::map<MtrId, DBID> mtr2db_;

    std::atomic<DBID> lastDBID_;
    mutable std::mutex mapMutex_;
    mutable std::mutex generateMutex_;
};

} // namespace maps::wiki::masstransit
