#include "log.h"

namespace maps::wiki::masstransit {

DataErrorLog::DataErrorLog(const std::string& logFilePath)
{
    if (!logFilePath.empty()) {
        const auto openFlags = std::ios_base::out|std::ios_base::app;
        logStream_ = std::make_shared<std::ofstream>(logFilePath, openFlags);
    }
}

void
DataErrorLog::putMessage(const DataErrorMessage& msg)
{
    log8::putMessage(msg.message());
    if (logStream_) {
        *logStream_ << msg.text();
    }
}

DataErrorMessage::DataErrorMessage(DataErrorLog& log)
    : log_(log)
{
    msg_.reset(new log8::Message(log8::Level::ERROR));
}

DataErrorMessage::~DataErrorMessage()
{
    log_.putMessage(*this);
}

const log8::Message&
DataErrorMessage::message() const
{
    return *msg_;
}

std::string
DataErrorMessage::text() const
{
    return std::string(message().text()) + "\n";
}

} // namespace maps::wiki::masstransit
