#pragma once

#include <maps/libs/log8/include/log8.h>

#include <fstream>
#include <memory>

namespace maps::wiki::masstransit {

class DataErrorMessage;

class DataErrorLog {
public:
    explicit DataErrorLog(const std::string& logFilePath);
    void putMessage(const DataErrorMessage& message);

private:
    std::shared_ptr<std::ofstream> logStream_;
};

class DataErrorMessage {
public:
    explicit DataErrorMessage(DataErrorLog& log);
    DataErrorMessage(DataErrorMessage&& deMsg) = default;

    ~DataErrorMessage();

    template<typename T>
    DataErrorMessage& operator<<(const T& item) {
        *msg_ << item;
        return *this;
    }

    const log8::Message& message() const;
    std::string text() const;

private:
    DataErrorLog& log_;
    std::unique_ptr<log8::Message> msg_;
};

} // namespace maps::wiki::masstransit
