#pragma once

#include <string>

namespace maps::wiki::masstransit {

const std::string FIELD_SEPARATOR = "\t";
const std::string FLAG_SEPARATOR = ",";

const std::string STR_NOMINATIVE = "nominative";

namespace filename {

const std::string ALIASES = "aliases";
const std::string BOARDINGS = "boardings";
const std::string CALENDAR = "calendar";
const std::string CONNECTOR_GEOMETRY = "connector_geometry";
const std::string CONNECTORS = "connectors";
const std::string FREQUENCY = "frequency";
const std::string GEOMETRY = "geometry";
const std::string L10N = "l10n";
const std::string ROUTES = "routes";
const std::string STOP_CLOSURES = "stop_closures";
const std::string STOPS = "stops";
const std::string THREAD_CLOSURES = "thread_closures";
const std::string THREAD_STOPS = "thread_stops";
const std::string THREADS = "threads";
const std::string TIMETABLE = "timetable";
const std::string TRANSITIONS = "transitions";
const std::string TRAVEL_TIME = "travel_time";

} // namespace filename

namespace ymapsdf {

const std::string ACCESS_ID = "access_id";
const std::string BACK_BUS = "back_bus";
const std::string COND_TYPE = "cond_type";
const std::string EL_ID = "el_id";
const std::string F_JC_ID = "f_jc_id";
const std::string F_ZLEV = "f_zlev";
const std::string FROM_RD_EL_ID = "from_rd_el_id";
const std::string FT_TYPE_ID = "ft_type_id";
const std::string ID = "id";
const std::string IS_LOCAL = "is_local";
const std::string LANG = "lang";
const std::string NAME = "name";
const std::string NAME_TYPE = "name_type";
const std::string ONEWAY = "oneway";
const std::string P_FT_ID = "p_ft_id";
const std::string P_FT_TYPE_ID = "p_ft_type_id";
const std::string SHAPE = "SHAPE";
const std::string SOURCE_ID = "source_id";
const std::string T_JC_ID = "t_jc_id";
const std::string T_ZLEV = "t_zlev";
const std::string TO_RD_EL_IDS = "to_rd_el_ids";
const std::string VIA_RD_JC_ID = "via_jc_id";

} // namespace ymapsdf

namespace value {

const std::string SOURCE_TYPE_MTR = "3";

const size_t ACCESS_BUS = 1 << 1;

} // namespace value

namespace attr {

const std::string ALTERNATIVE = "alternative";
const std::string BOARDING_OPTIONS = "boarding_options";
const std::string CLOSURE = "closure";
const std::string COLOR = "color";
const std::string DATE_END = "date_end";
const std::string DATE_START = "date_start";
const std::string DEPARTURE_TIME = "departure_time";
const std::string FREQ = "freq";
const std::string IS_PREDICTABLE = "is_predictable";
const std::string IS_TERMINAL = "is_terminal";
const std::string IS_VIRTUAL = "is_virtual";
const std::string NO_DISEMBARKATION = "no_disembarkation";
const std::string NO_EMBARKATION = "no_embarkation";
const std::string ONEWAY = "oneway";
const std::string PRIORITY = "priority";
const std::string TIME = "time";
const std::string TIME_END = "time_end";
const std::string TIME_START = "time_start";
const std::string TRAVEL_TIME = "travel_time";
const std::string TYPE = "type";
const std::string WAIT_TIME = "wait_time";
const std::string WAYPOINT = "waypoint";
const std::string WEEK_DAY = "day";

} // namespace attr

namespace role {

const std::string ALIAS = "alias";
const std::string APPLIED_TO = "applied_to";
const std::string ASSIGNED_BUS = "assigned_bus";
const std::string ASSIGNED_METRO = "assigned_metro";
const std::string ASSIGNED_THREAD = "assigned_thread";
const std::string ASSIGNED_THREAD_STOP = "assigned_thread_stop";
const std::string ASSIGNED_TRAM = "assigned_tram";
const std::string ASSIGNED_WATERWAY = "assigned_waterway";
const std::string DST_THREAD = "dst_thread";
const std::string EXIT = "exit";
const std::string PART = "part";
const std::string PREVIOUS = "previous";
const std::string SRC_THREAD = "src_thread";
const std::string STATION = "station";
const std::string STATION_A = "station_a";
const std::string STATION_B = "station_b";
const std::string STATION_NEXT = "station_next";
const std::string STATION_PREVIOUS = "station_previous";

} // namespace role

} // namespace maps::wiki::masstransit
