#pragma once

#include "db_helper.h"
#include "id_map.h"
#include "log.h"
#include "object.h"
#include "object_handler.h"
#include "params.h"

#include "categories/boardings.h"
#include "categories/calendar.h"
#include "categories/connector.h"
#include "categories/connector_geometry.h"
#include "categories/l10n.h"
#include "categories/operator.h"
#include "categories/road_conditions.h"
#include "categories/route.h"
#include "categories/route_aliases.h"
#include "categories/stop.h"
#include "categories/stop_closure.h"
#include "categories/thread.h"
#include "categories/thread_closure.h"
#include "categories/thread_geometry.h"
#include "categories/thread_stops.h"
#include "categories/transitions.h"
#include "categories/travel_time.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

namespace maps::wiki::masstransit {

struct ThreadGeometry;

class Masstransit {
public:
    Masstransit(const Params& params);

    bool failed() const;
    void fail(const std::string& name);

    void readFromYmapsdf(pgpool3::Pool& ymapsdfPool, const std::string& schemaName);
    void writeToMtr(const std::string& dirPath);

    DataErrorLog& log();

private:
    void safeRunner(const ThreadPool::Functor& f, const std::string& name);
    void addSafeTask(ThreadPool& taskPool, const ThreadPool::Functor& f, const std::string& name);

public:
    ObjectMap<Operator> operators;
    ObjectMap<Stop> stops;
    ObjectMap<Route> routes;
    ObjectMap<Thread> threads;
    ObjectMap<ThreadStops> threadStops;
    ObjectMap<ThreadGeometry> threadGeometries;
    ObjectMap<Connector> connectors;
    ObjectMap<ThreadGeometry> connectorGeometries;
    ObjectMap<Transition> transitions;
    ObjectMap<Localization> localizations;
    ObjectMap<TravelTime> travelTimes;
    ObjectMap<Calendar> calendars;
    ObjectMap<RouteAlias> routeAliases;
    ObjectMap<Boarding> boardings;

    ObjectMap<RoadConditions> roadConditions;

    ObjectMap<StopClosure> stopClosures;
    ObjectMap<ThreadClosure> threadClosures;

    IdMap idMap;
    const Params& params;

private:
    std::atomic<bool> failed_;
    std::vector<std::shared_ptr<MtrObjectHandler>> mtrObjectHandlers_;
    std::vector<std::shared_ptr<YmapsdfObjectHandler>> ymapsdfObjectHandlers_;
    DataErrorLog dataErrorLog_;
};

} // namespace maps::wiki::masstransit
