#include "mtr_object_handler.h"

#include "magic_strings.h"
#include "masstransit.h"

#include <fstream>
#include <iomanip>

namespace maps::wiki::masstransit {

namespace {

std::string
filePath(const std::string& dirPath, const std::string& fileName)
{
    if (dirPath.back() == '/') {
        return dirPath + fileName;
    } else {
        return dirPath + "/" + fileName;
    }
}

} // namespace

MtrObjectHandler::MtrObjectHandler(
        Masstransit& masstransit,
        ObjectMapBase& objectMap)
    : ObjectHandler(masstransit, objectMap)
{ }

void
MtrObjectHandler::write(const std::string& dirPath)
{
    StreamMap ostreams;
    for (const auto& fileName : fileNames()) {
        ostreams[fileName] = std::ofstream(filePath(dirPath, fileName));
        ostreams[fileName] << std::setprecision(masstransit_.params.precision);
    }
    for (const auto& object : objects()) {
        writeObject(ostreams, *object);
    }
}

} // namespace maps::wiki::masstransit
