#pragma once

#include "object.h"
#include "object_handler.h"

#include <fstream>
#include <unordered_map>

namespace maps::wiki::masstransit {

using StreamMap = std::unordered_map<std::string, std::ofstream>;

class MtrObjectHandler : public ObjectHandler {
public:
    MtrObjectHandler(Masstransit& masstransit, ObjectMapBase& objectMap);

    virtual StringVector fileNames() const = 0;
    void write(const std::string& dirPath);

private:
    virtual void writeObject(StreamMap& ostreams, const Object& object) = 0;
};

} // namespace maps::wiki::masstransit
